@extends('admin.layouts.home')

@section('title', 'Featured Events')

@section('styles')
<style>
    .event-card {
        transition: transform 0.2s;
        height: 100%;
    }
    .event-card:hover {
        transform: translateY(-5px);
    }
    .event-image {
        height: 180px;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }
    .event-card-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .event-badge {
        position: absolute;
        top: 10px;
        right: 10px;
    }
    .event-date {
        position: absolute;
        top: 10px;
        left: 10px;
        background-color: rgba(255, 255, 255, 0.9);
        padding: 5px 10px;
        border-radius: 5px;
        font-weight: bold;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Featured Events</h1>
        <div>
            <a href="{{ route('admin.events.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to All Events
            </a>
        </div>
    </div>
    
    <!-- Info Card -->
    <div class="card mb-4 border-left-warning">
        <div class="card-body">
            <h5 class="mb-2"><i class="fas fa-star text-warning"></i> Featured Events</h5>
            <p class="mb-0">
                Featured events are displayed prominently throughout the application. They appear in the "Featured Events" section on the home page and discovery feeds.
                To add or remove an event from the featured list, go to the event details page or use the toggle button below.
            </p>
        </div>
    </div>
    
    <!-- Featured Events -->
    @if($featuredEvents->isEmpty())
        <div class="alert alert-info text-center py-4">
            <i class="fas fa-info-circle fa-2x mb-3"></i>
            <h4>No Featured Events</h4>
            <p>You haven't featured any events yet. Go to the Events list and click the star icon to feature an event.</p>
            <a href="{{ route('admin.events.index') }}" class="btn btn-primary mt-2">
                <i class="fas fa-list"></i> Go to Events List
            </a>
        </div>
    @else
        <div class="row">
            @foreach($featuredEvents as $event)
                <div class="col-xl-3 col-md-4 col-sm-6 mb-4">
                    <div class="card shadow event-card">
                        <!-- Featured Badge -->
                        <div class="event-badge">
                            <span class="badge badge-warning">
                                <i class="fas fa-star"></i> Featured
                            </span>
                        </div>

                        <!-- Event Image -->
                        <div class="event-image" 
                             style="background-image: url('{{ $event->image ? asset('storage/'.$event->image) : asset('img/default-event-cover.jpg') }}');">
                            <!-- Event Date Badge -->
                            <div class="event-date">
                                <i class="fas fa-calendar-day"></i> {{ \Carbon\Carbon::parse($event->event_date)->format('M d') }}
                            </div>
                        </div>
                        
                        <div class="card-body">
                            <h5 class="card-title">{{ $event->title }}</h5>
                            <p class="card-text" style="height: 50px; overflow: hidden;">
                                {{ Str::limit($event->description, 100) }}
                            </p>
                            
                            <div class="d-flex justify-content-between">
                                <small class="text-muted">
                                    <i class="fas fa-users"></i> {{ $event->attendees_count ?? 0 }} attendees
                                </small>
                                <small class="text-muted">
                                    <i class="fas fa-map-marker-alt"></i> {{ Str::limit($event->location, 15) }}
                                </small>
                            </div>
                        </div>
                        
                        <div class="card-footer event-card-footer">
                            <a href="{{ route('admin.events.show', $event->id) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <form action="{{ route('admin.events.toggle-featured', $event->id) }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-warning">
                                    <i class="fas fa-star-half-alt"></i> Unfeature
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <!-- Pagination -->
        <div class="row">
            <div class="col-12">
                {{ $featuredEvents->links('pagination::bootstrap-5') }}
            </div>
        </div>
    @endif

    <!-- Suggestions Card -->
    @if($suggestedEvents->isNotEmpty())
        <div class="card shadow mb-4 mt-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Suggested Events to Feature</h6>
            </div>
            <div class="card-body">
                <p>These events are popular and might be good candidates for featuring:</p>
                
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Event Name</th>
                                <th>Date</th>
                                <th>Location</th>
                                <th>Attendees</th>
                                <th>Interests</th>
                                <th>Creator</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($suggestedEvents as $event)
                                <tr>
                                    <td>
                                        <a href="{{ route('admin.events.show', $event->id) }}">
                                            {{ $event->title }}
                                        </a>
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($event->event_date)->format('M d, Y') }}</td>
                                    <td>{{ Str::limit($event->location, 30) }}</td>
                                    <td>{{ $event->attendees_count }}</td>
                                    <td>{{ $event->interests_count }}</td>
                                    <td>
                                        @if($event->creator)
                                            <a href="{{ url('admin/users', $event->creator->id) }}">
                                                {{ $event->creator->name }}
                                            </a>
                                        @else
                                            <span class="text-muted">Unknown</span>
                                        @endif
                                    </td>
                                    <td>
                                        <form action="{{ route('admin.events.toggle-featured', $event->id) }}" method="POST">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-outline-warning">
                                                <i class="far fa-star"></i> Feature
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection 