@extends('admin.layouts.home')

@section('title', 'Create Custom Page')

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Create Custom Page</h1>
            <a href="{{ route('admin.custom-pages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Pages
            </a>
        </div>

        <!-- Content Row -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Page Information</h6>
                    </div>
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form action="{{ route('admin.custom-pages.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <label for="title">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="slug">Slug <span class="text-muted">(Optional - will be generated from title if not provided)</span></label>
                                        <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug') }}">
                                        <small class="form-text text-muted">The slug is used in the URL of the page. Use only letters, numbers, and hyphens.</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="content">Content <span class="text-danger">*</span></label>
                                        <textarea class="form-control summernote" id="content" name="content" rows="15">{{ old('content') }}</textarea>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h6 class="m-0 font-weight-bold text-primary">Publication Settings</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="active" name="active" value="1" {{ old('active') ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="active">Active</label>
                                                </div>
                                                <small class="form-text text-muted">Enable to make this page visible to visitors.</small>
                                            </div>
                                            
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="show_in_header" name="show_in_header" value="1" {{ old('show_in_header') ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="show_in_header">Show in Header</label>
                                                </div>
                                                <small class="form-text text-muted">Display this page in the website header navigation.</small>
                                            </div>
                                            
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="show_in_footer" name="show_in_footer" value="1" {{ old('show_in_footer') ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="show_in_footer">Show in Footer</label>
                                                </div>
                                                <small class="form-text text-muted">Display this page in the website footer navigation.</small>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="order">Display Order</label>
                                                <input type="number" class="form-control" id="order" name="order" value="{{ old('order', 0) }}" min="0">
                                                <small class="form-text text-muted">Pages with lower numbers will display first.</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="card">
                                        <div class="card-header">
                                            <h6 class="m-0 font-weight-bold text-primary">SEO Settings</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label for="meta_description">Meta Description</label>
                                                <textarea class="form-control" id="meta_description" name="meta_description" rows="3">{{ old('meta_description') }}</textarea>
                                                <small class="form-text text-muted">A brief description of the page for search engines. Recommended length: 150-160 characters.</small>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="meta_keywords">Meta Keywords</label>
                                                <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords') }}">
                                                <small class="form-text text-muted">Comma-separated keywords related to this page.</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">Create Page</button>
                                <a href="{{ route('admin.custom-pages.index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Summernote editor
            $('.summernote').summernote({
                height: 300,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });

            // Auto-generate slug from title
            $('#title').on('blur', function() {
                if ($('#slug').val() === '') {
                    const title = $(this).val();
                    const slug = title.toLowerCase()
                        .replace(/[^\w\s-]/g, '')
                        .replace(/[\s_-]+/g, '-')
                        .replace(/^-+|-+$/g, '');
                    $('#slug').val(slug);
                }
            });
        });
    </script>
@endpush 