@extends('admin.layouts.home')

@section('title', 'Manage Courses')

@php
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Str;
@endphp

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">All Courses</h4>
                    <div>
                        <a href="{{ route('admin.courses.stats') }}" class="btn btn-info btn-sm">
                            <i class="fas fa-chart-bar"></i> Course Statistics
                        </a>
                        <a href="{{ route('admin.courses.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add Course
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Thumbnail</th>
                                    <th>Title</th>
                                    <th>Instructor</th>
                                    <th>Category</th>
                                    <th>Price</th>
                                    <th>Students</th>
                                    <th>Rating</th>
                                    <th>Status</th>
                                    <th>Featured</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($courses as $course)
                                    <tr>
                                        <td>{{ $course->id }}</td>
                                        <td>
                                            @if($course->thumbnail)
                                                <img src="{{ Storage::url($course->thumbnail) }}" alt="{{ $course->title }}" class="img-thumbnail" style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-secondary text-white d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                                    <i class="fas fa-image"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $course->title }}</strong>
                                            <br>
                                            <small class="text-muted">{{ Str::limit($course->description, 50) }}</small>
                                        </td>
                                        <td>{{ $course->instructor->name ?? 'N/A' }}</td>
                                        <td>{{ $course->category->name ?? 'N/A' }}</td>
                                        <td>
                                            @if($course->price == 0)
                                                <span class="badge bg-success">Free</span>
                                            @else
                                                ${{ number_format($course->price, 2) }}
                                                @if($course->discount_price)
                                                    <br><small class="text-danger">${{ number_format($course->discount_price, 2) }}</small>
                                                @endif
                                            @endif
                                        </td>
                                        <td>{{ $course->total_students ?? 0 }}</td>
                                        <td>
                                            @if($course->average_rating)
                                                <span class="badge bg-warning">{{ number_format($course->average_rating, 1) }} <i class="fas fa-star"></i></span>
                                            @else
                                                <span class="text-muted">No ratings</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $course->is_published ? 'success' : 'secondary' }}">
                                                {{ $course->is_published ? 'Published' : 'Draft' }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($course->is_featured)
                                                <span class="badge bg-warning"><i class="fas fa-star"></i> Featured</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex">
                                                <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-sm btn-info me-1" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.courses.edit', $course->id) }}" class="btn btn-sm btn-primary me-1" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.courses.toggle-status', $course->id) }}" method="POST" class="d-inline me-1">
                                                    @csrf
                                                    @method('PUT')
                                                    <button type="submit" class="btn btn-sm {{ $course->is_published ? 'btn-warning' : 'btn-success' }}" title="{{ $course->is_published ? 'Unpublish' : 'Publish' }}">
                                                        <i class="fas {{ $course->is_published ? 'fa-eye-slash' : 'fa-eye' }}"></i>
                                                    </button>
                                                </form>
                                                <form action="{{ route('admin.courses.toggle-featured', $course->id) }}" method="POST" class="d-inline me-1">
                                                    @csrf
                                                    @method('PUT')
                                                    <button type="submit" class="btn btn-sm {{ $course->is_featured ? 'btn-secondary' : 'btn-warning' }}" title="{{ $course->is_featured ? 'Remove from Featured' : 'Add to Featured' }}">
                                                        <i class="fas fa-star"></i>
                                                    </button>
                                                </form>
                                                <form action="{{ route('admin.courses.destroy', $course->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this course?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="11" class="text-center">No courses found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $courses->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

