@extends('admin.layouts.home')

@section('title', 'Edit Course')

@php
    use Illuminate\Support\Facades\Storage;
@endphp

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Edit Course</h4>
                    <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.courses.update', $course->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-8">
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h5 class="mb-0">Course Information</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="title" class="form-label">Course Title <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $course->title) }}" required>
                                        </div>

                                        <div class="mb-3">
                                            <label for="category_id" class="form-label">Category <span class="text-danger">*</span></label>
                                            <select class="form-control" id="category_id" name="category_id" required>
                                                <option value="">Select Category</option>
                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}" {{ old('category_id', $course->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                                            <textarea class="form-control" id="description" name="description" rows="5" required>{{ old('description', $course->description) }}</textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label for="requirements" class="form-label">Requirements</label>
                                            <textarea class="form-control" id="requirements" name="requirements" rows="3">{{ old('requirements', $course->requirements) }}</textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label for="what_you_will_learn" class="form-label">What You Will Learn</label>
                                            <textarea class="form-control" id="what_you_will_learn" name="what_you_will_learn" rows="3">{{ old('what_you_will_learn', $course->what_you_will_learn) }}</textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label for="target_audience" class="form-label">Target Audience</label>
                                            <textarea class="form-control" id="target_audience" name="target_audience" rows="3">{{ old('target_audience', $course->target_audience) }}</textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h5 class="mb-0">Pricing</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="price" class="form-label">Price <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" class="form-control" id="price" name="price" value="{{ old('price', $course->price) }}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="discount_price" class="form-label">Discount Price</label>
                                                    <input type="number" step="0.01" class="form-control" id="discount_price" name="discount_price" value="{{ old('discount_price', $course->discount_price) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label for="discount_ends_at" class="form-label">Discount Ends At</label>
                                            <input type="date" class="form-control" id="discount_ends_at" name="discount_ends_at" value="{{ old('discount_ends_at', $course->discount_ends_at ? $course->discount_ends_at->format('Y-m-d') : '') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h5 class="mb-0">Course Settings</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="level" class="form-label">Level <span class="text-danger">*</span></label>
                                            <select class="form-control" id="level" name="level" required>
                                                <option value="beginner" {{ old('level', $course->level) == 'beginner' ? 'selected' : '' }}>Beginner</option>
                                                <option value="intermediate" {{ old('level', $course->level) == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                                                <option value="advanced" {{ old('level', $course->level) == 'advanced' ? 'selected' : '' }}>Advanced</option>
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label for="language" class="form-label">Language <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="language" name="language" value="{{ old('language', $course->language) }}" required>
                                        </div>

                                        <div class="mb-3">
                                            <label for="thumbnail" class="form-label">Thumbnail</label>
                                            @if($course->thumbnail)
                                                <div class="mb-2">
                                                    <img src="{{ Storage::url($course->thumbnail) }}" alt="Current thumbnail" class="img-thumbnail" style="max-width: 100%; height: auto;">
                                                </div>
                                            @endif
                                            <input type="file" class="form-control" id="thumbnail" name="thumbnail" accept="image/*">
                                            <small class="text-muted">Max size: 2MB. Leave empty to keep current image.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="preview_video" class="form-label">Preview Video URL</label>
                                            <input type="url" class="form-control" id="preview_video" name="preview_video" value="{{ old('preview_video', $course->preview_video) }}">
                                        </div>

                                        <div class="mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured" value="1" {{ old('is_featured', $course->is_featured) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="is_featured">
                                                    Featured Course
                                                </label>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="is_published" name="is_published" value="1" {{ old('is_published', $course->is_published) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="is_published">
                                                    Publish Course
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Course
                                </button>
                                <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary">
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

