@extends('admin.layouts.home')

@section('title', __('Edit Blog Category'))

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Edit Blog Category') }}: {{ $blogCategory->name }}</h1>
        <a href="{{ route('admin.blog-categories.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left mr-1"></i> {{ __('Back to Categories') }}
        </a>
    </div>

    <!-- Category Form Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Category Information') }}</h6>
        </div>
        <div class="card-body">
            @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form action="{{ route('admin.blog-categories.update', $blogCategory->id) }}" method="POST" id="categoryForm">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-8">
                        <!-- Basic Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">{{ __('Basic Information') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="name">{{ __('Category Name') }} <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           id="name" 
                                           name="name" 
                                           value="{{ old('name', $blogCategory->name) }}" 
                                           placeholder="{{ __('Enter category name') }}"
                                           required
                                           autofocus>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">{{ __('This will be used to generate the URL slug automatically.') }}</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="description">{{ __('Description') }}</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" 
                                              id="description" 
                                              name="description" 
                                              rows="4" 
                                              placeholder="{{ __('Enter category description (optional)') }}">{{ old('description', $blogCategory->description) }}</textarea>
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">{{ __('A brief description of this category. This will help users understand what content belongs here.') }}</small>
                                </div>
                            </div>
                        </div>

                        <!-- Preview Section -->
                        <div class="card mb-4" id="previewSection">
                            <div class="card-header">
                                <h6 class="mb-0">{{ __('Preview') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="category-icon me-3">
                                        <i class="fas fa-folder text-primary fa-2x"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-1" id="previewName">{{ $blogCategory->name }}</h5>
                                        <p class="text-muted mb-1" id="previewDescription">{{ $blogCategory->description ?: __('Category description will appear here...') }}</p>
                                        <small class="text-muted">
                                            <code id="previewSlug">{{ $blogCategory->slug }}</code>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <!-- Status Options -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">{{ __('Status Options') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="status">{{ __('Status') }}</label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror">
                                        <option value="1" {{ old('status', $blogCategory->status) == '1' ? 'selected' : '' }}>
                                            {{ __('Active') }}
                                        </option>
                                        <option value="0" {{ old('status', $blogCategory->status) == '0' ? 'selected' : '' }}>
                                            {{ __('Inactive') }}
                                        </option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">{{ __('Active categories will be visible to users.') }}</small>
                                </div>
                            </div>
                        </div>

                        <!-- Current Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">{{ __('Current Information') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>{{ __('Current Slug') }}</label>
                                    <input type="text" class="form-control" value="{{ $blogCategory->slug }}" disabled>
                                    <small class="form-text text-muted">{{ __('The slug is automatically generated from the name.') }}</small>
                                </div>
                                
                                <div class="form-group">
                                    <label>{{ __('Blogs in this category') }}</label>
                                    <div>
                                        <span class="badge bg-info">{{ $blogCategory->blogs->count() }}</span>
                                    </div>
                                </div>
                                
                                <div class="form-group mb-0">
                                    <p class="mb-1"><strong>{{ __('Created') }}:</strong> {{ $blogCategory->created_at->format('M d, Y H:i') }}</p>
                                    <p class="mb-0"><strong>{{ __('Last Updated') }}:</strong> {{ $blogCategory->updated_at->format('M d, Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary btn-lg px-5">
                        <i class="bi bi-save mr-2"></i> {{ __('Update Category') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-generate slug from name
    $('#name').on('input', function() {
        var name = $(this).val();
        var slug = name.toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '') // Remove special characters
            .replace(/\s+/g, '-') // Replace spaces with hyphens
            .replace(/-+/g, '-') // Replace multiple hyphens with single
            .trim();
        
        // Update preview
        updatePreview(name, slug);
    });

    // Update description preview
    $('#description').on('input', function() {
        var description = $(this).val();
        $('#previewDescription').text(description || '{{ __("Category description will appear here...") }}');
    });

    function updatePreview(name, slug) {
        if (name) {
            $('#previewName').text(name);
            $('#previewSlug').text(slug);
        }
    }

    // Form validation
    $('#categoryForm').on('submit', function(e) {
        var name = $('#name').val().trim();
        if (!name) {
            e.preventDefault();
            $('#name').addClass('is-invalid');
            return false;
        }
    });

    // Real-time validation
    $('#name').on('blur', function() {
        var name = $(this).val().trim();
        if (name) {
            $(this).removeClass('is-invalid');
        } else {
            $(this).addClass('is-invalid');
        }
    });
});
</script>
@endpush