<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('posts_media', function (Blueprint $table) {
            if (!Schema::hasColumn('posts_media', 'mime_type')) {
                $table->string('mime_type', 150)->nullable()->after('media_path');
            }
            if (!Schema::hasColumn('posts_media', 'original_name')) {
                $table->string('original_name', 255)->nullable()->after('mime_type');
            }
            if (!Schema::hasColumn('posts_media', 'file_size')) {
                $table->unsignedBigInteger('file_size')->nullable()->after('original_name');
            }
        });
    }

    public function down(): void
    {
        Schema::table('posts_media', function (Blueprint $table) {
            if (Schema::hasColumn('posts_media', 'file_size')) {
                $table->dropColumn('file_size');
            }
            if (Schema::hasColumn('posts_media', 'original_name')) {
                $table->dropColumn('original_name');
            }
            if (Schema::hasColumn('posts_media', 'mime_type')) {
                $table->dropColumn('mime_type');
            }
        });
    }
};


