<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            if (!Schema::hasColumn('posts', 'gif_url')) {
                $table->string('gif_url', 512)->nullable()->after('video_thumbnail_url');
            }
            if (!Schema::hasColumn('posts', 'gif_title')) {
                $table->string('gif_title', 255)->nullable()->after('gif_url');
            }
            if (!Schema::hasColumn('posts', 'gif_provider')) {
                $table->string('gif_provider', 100)->nullable()->after('gif_title');
            }
        });
    }

    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            if (Schema::hasColumn('posts', 'gif_provider')) {
                $table->dropColumn('gif_provider');
            }
            if (Schema::hasColumn('posts', 'gif_title')) {
                $table->dropColumn('gif_title');
            }
            if (Schema::hasColumn('posts', 'gif_url')) {
                $table->dropColumn('gif_url');
            }
        });
    }
};


