<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('event_type'); // message.sent, conversation.created, etc.
            $table->json('event_data'); // Normalized event payload
            $table->unsignedBigInteger('related_id')->nullable(); // conversation_id, message_id, etc.
            $table->string('related_type')->nullable(); // conversation, message, etc.
            $table->timestamp('created_at')->useCurrent();

            $table->index(['user_id', 'id']); // For long-polling queries
            $table->index(['user_id', 'event_type', 'created_at']);
            $table->index(['related_type', 'related_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_events');
    }
};
