<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('message_receipts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('message_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['delivered', 'seen'])->default('delivered');
            $table->timestamp('receipt_at')->useCurrent();
            $table->timestamps();

            $table->unique(['message_id', 'user_id', 'type']);
            $table->index(['user_id', 'type', 'receipt_at']);
            $table->index(['message_id', 'type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('message_receipts');
    }
};
