<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\MediaService;
use App\Facades\Media;

class MediaServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('media', function ($app) {
            return new MediaService();
        });
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        // Publish configuration file
        $this->publishes([
            __DIR__.'/../../config/media.php' => config_path('media.php'),
        ], 'media-config');
    }
} 