<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SpaceMember extends Model
{
    use HasFactory,SoftDeletes;
    
    protected $guarded = [];
    public function checkMemberExist($space_id,$user_id)
    {
        $checkMember = $this->where(['user_id'=>$user_id,'space_id'=>$space_id])->first();
        if(empty($checkMember))
        {
            return true;
        }
        return false;
    }
    public function addSpaceMember($space_id,$user_id)
    {
        $this->create(['user_id'=>$user_id,'space_id'=>$space_id]);
    }
    public function createSpaceMember($privacy,$user_id,$space_id,$is_cohost)
    {   
        $this->user_id = $user_id;
        $this->is_cohost = $is_cohost;
        $this->space_id = $space_id;
        $this->join_status = ($privacy==3)?0:1;
        $this->save();
    }
    public function canJoinSpace($privacy,$user_id,$space_id)
    {
        if($privacy==3)
        {
            $canJoin = SpaceCheckIn::where(['user_id'=>$user_id,'space_id'=>$space_id,'is_private_space'=>1])->count();
            if($canJoin>0)
            {
                return true;
            }
            return false;
        }
        return true;
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function space(){
        return $this->belongsTo(Space::class, 'space_id');
    }
}
