<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Setting extends Model
{
    protected $table = 'settings';
    protected $guarded = [];

    protected static function boot()
    {
        parent::boot();

        static::saved(function () {
            self::refreshCache();
        });

        static::deleted(function () {
            self::refreshCache();
        });
    }
    public static function getSettings()
    {
        Cache::forget('app_settings');
        return Cache::rememberForever('app_settings', function () {
            return self::pluck('val', 'name')->toArray();
        });
    }

    public static function refreshCache()
    {
        Cache::forget('app_settings');
        Cache::rememberForever('app_settings', function () {
            return self::pluck('val', 'name')->toArray();
        });
    }
}
