<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Poll extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['title', 'is_active'];
    protected $casts = ['is_active' => 'boolean'];

    public function options()
    {
        return $this->hasMany(PollOption::class);
    }

    public function votes()
    {
        return $this->hasManyThrough(
            PollVote::class,
            PollOption::class,
            'poll_id',  // Foreign key on poll_options table
            'option_id' // Foreign key on poll_votes table
        );
    }

    public function withOptions()
    {
        return $this->with('options');

    }
}