<?php

namespace App\Models\Courses;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;



class CourseSection extends Model
{
    protected $fillable = ['course_id', 'title', 'description', 'sort_order'];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function lessons()
    {
        return $this->hasMany(CourseLesson::class, 'section_id')->orderBy('sort_order');
    }

    public function getTotalDuration()
    {
        return $this->lessons->sum('duration');
    }

    public function getLessonCount()
    {
        return $this->lessons->count();
    }
}