<?php

namespace App\Models\Courses;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class CourseCategory extends Model
{
    protected $fillable = ['name', 'slug', 'icon', 'description', 'is_active'];

    public function courses()
    {
        return $this->hasMany(Course::class, 'category_id');
    }

    // Auto-generate slug from name
    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($category) {
            if (empty($category->slug)) {
                $category->slug = Str::slug($category->name);
            }
        });
    }

    public function getActiveCoursesCount()
    {
        return $this->courses()->where('is_published', true)->count();
    }
}
