<?php


namespace App\Models\BloodBank;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BloodDrive extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'blood_bank_id',
        'organizer_name',
        'organizer_phone',
        'organizer_email',
        'location',
        'latitude',
        'longitude',
        'start_datetime',
        'end_datetime',
        'registration_limit'
    ];

    protected $casts = [
        'start_datetime' => 'datetime',
        'end_datetime' => 'datetime'
    ];

    public function bloodBank()
    {
        return $this->belongsTo(BloodBank::class);
    }

    public function registrations()
    {
        return $this->hasMany(DriveRegistration::class);
    }

    // Check if drive is in progress
    public function isInProgress()
    {
        $now = now();
        return $now->between($this->start_datetime, $this->end_datetime);
    }

    // Check if registration is full
    public function isRegistrationFull()
    {
        if (!$this->registration_limit) {
            return false;
        }
        
        return $this->registrations()->count() >= $this->registration_limit;
    }
}
