<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Block extends Model
{
    use HasFactory;

    protected $fillable = ['blocker', 'blocked'];

    public function blockerUser()
    {
        return $this->belongsTo(User::class, 'blocker');
    }

    public function blockedUser()
    {
        return $this->belongsTo(User::class, 'blocked');
    }
}
