<?php

namespace App\Http\Resources;

use App\Models\Friend;
use App\Models\Follower;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        $loggedInUserId = Auth::id();
        return [
            'id' => $this->id,
            'username' => $this->username,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'avatar' => getMedia($this->avatar, 'avatar'),
            'cover' => getMedia($this->cover, 'cover'),
            'bio' => $this->bio,
            'date_of_birth' => $this->date_of_birth,
            'gender' => $this->gender,
            'phone' => $this->phone,
            'country' => $this->country,
            'state' => $this->state,
            'city' => $this->city,
            'address' => $this->address,
            'created_at' => $this->created_at,
            'last_seen' => $this->last_seen,
            'followers_count' => $this->followers()->count(),
            'mutual_friends' => Friend::getMutualFriendsCount($this->id, $loggedInUserId),
            'is_following' => Follower::isFollowing($loggedInUserId, $this->id),
            'is_friend' => Friend::isFriend($loggedInUserId, $this->id),
            'workspace' => $this->workspace,
            'relationship' => $this->relationship,

            'friend_request_status' => Friend::pendingRequestStatus($loggedInUserId, $this->id),
        ];
    }
}
