<?php

namespace App\Http\Resources;

use App\Models\Marketplace\OrderProduct;
use App\Models\Marketplace\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class StoreResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'location' => $this->location,
            'status' => $this->status,
            'logo' => getMedia($this->logo,'avatar'),
            'banner' => getMedia($this->banner,'cover'),
            'contact_email' => $this->contact_email,
            'contact_phone' => $this->contact_phone,
            'social_links' => $this->social_links,
            'shipping_policy' => $this->shipping_policy,
            'return_policy' => $this->return_policy,
            'is_featured' => $this->is_featured,
            'average_rating' => round($this->average_rating, 1)??'0',
            'total_products' => Product::where('store_id',$this->id)->count(),
            'owner' => [
                'id' => $this->owner->id,
                'name' => $this->owner->username,
                'profile_photo' => getMedia($this->owner->profile,'avatar'),
            ],
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
} 