<?php

namespace App\Http\Resources;

use App\Models\Page;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class PageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        // Check if the resource is null or not a valid Page model
        if (!$this->resource || !($this->resource instanceof Page)) {
            return null;
        }

        $pageModel = New Page;
        return [
            'id' => $this->id,
            'page_username' => $this->page_username,
            'page_title' => $this->page_title,
            'page_description' => $this->page_description,
            'page_category' => __('Api.page_categories')[$this->page_category] ?? null,
            'website' => $this->website,
            'avatar' => getMedia($this->avatar,'avatar'),
            'cover' => getMedia($this->cover,'cover'),
            'likes_count' => $this->likes_count,
            'is_page_owner' => $this->user_id == Auth::id(),
            'is_liked' => $pageModel->isLikedByUser(Auth::id()),
            'is_verified' => $this->is_verified ?? false,
            'created_at' => $this->created_at ? $this->created_at->toDateTimeString() : null,
            'updated_at' => $this->updated_at ? $this->updated_at->toDateTimeString() : null,
        ];
    }
    
}
