<?php

namespace App\Http\Resources\Messenger;

use App\Http\Resources\UserShortResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MessageReceiptResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'message_id' => $this->message_id,
            'user' => new UserShortResource($this->whenLoaded('user')),
            'type' => $this->type,
            'receipt_at' => $this->receipt_at?->toISOString(),
        ];
    }
}
