<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\JobApplication;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class JobResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,

            // Basic Job Information
            'job_title' => $this->job_title,
            'job_description' => $this->job_description,
            'status' => $this->status,

            // Company Information
            'company_name' => $this->company_name,
            'company_website' => $this->company_website,
            'company_logo' => getMedia($this->company_logo),
            'hide_company' => (bool) $this->hide_company,

            // Location Information
            'work_location_type' => $this->work_location_type,
            'job_location' => $this->job_location,
            'city' => $this->city,
            'state' => $this->state,
            'country' => $this->country,

            // Category and Type
            'category' => new JobCategoryResource($this->category),
            'job_type' => $this->job_type,

            // Salary Information
            'minimum_salary' => $this->minimum_salary,
            'maximum_salary' => $this->maximum_salary,
            'currency' => $this->currency,
            'salary_date' => $this->salary_date,
            'salary_display' => $this->salary_display,

            // Requirements and Qualifications
            'experience_years' => $this->experience_years,
            'education_level' => $this->education_level,
            'key_responsibilities' => $this->key_responsibilities ? json_decode($this->key_responsibilities) : [],
            'requirements' => $this->requirements ? json_decode($this->requirements) : [],
            'skills' => $this->skills ? json_decode($this->skills) : [],
            'languages' => $this->languages ? json_decode($this->languages) : [],

            // Application Settings
            'application_method' => $this->application_method,
            'application_email' => $this->application_email,
            'application_url' => $this->application_url,
            'required_documents' => $this->required_documents ? json_decode($this->required_documents) : [],
            'screening_questions' => $this->screening_questions ? json_decode($this->screening_questions) : [],
            'positions_available' => $this->positions_available,

            // Benefits
            'benefits' => $this->benefits ? json_decode($this->benefits) : [],

            // Flags and Status
            'is_urgent_hiring' => (bool) $this->is_urgent_hiring,
            'is_featured' => (bool) $this->is_featured,

            // Dates
            'expiry_date' => $this->expiry_date,
            'created_at' => $this->created_at->toDateTimeString(),
            'updated_at' => $this->updated_at->toDateTimeString(),

            // Relationships
            'posted_by' => new UserShortResource($this->whenLoaded('user')),

            // Metadata
            'views' => $this->views ?? 0,
            'applications_count' => $this->whenLoaded('applications', function () {
                return $this->applications->count();
            }),
            'is_applied' => JobApplication::where(['job_id' => $this->id, 'user_id' => Auth::id()])->exists(),

            // Conditional Relationships
            'applications' => JobApplicationResource::collection($this->whenLoaded('applications')),
            'similar_jobs' => JobResource::collection($this->whenLoaded('similarJobs')),
        ];
    }
}
