<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class JobApplicationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'job_id' => $this->job_id,
            'phone' => $this->phone,
            'position' => $this->position,
            'previous_work' => $this->previous_work,
            'description' => $this->description,
            'location' => $this->location,
            'cv_file' => getMedia($this->cv_file),
            'applied_at' => $this->created_at->toDateTimeString(),
        ];
    }
}
