<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HashtagResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'url' => url("/api/hashtags/{$this->name}"), // Example URL structure
            'created_at' => $this->created_at->toISOString(),
            'updated_at' => $this->updated_at->toISOString(),
            'stats' => [
                'posts_count' => $this->whenCounted('posts'),
                'popularity' => $this->when(isset($this->popularity_score), $this->popularity_score),
            ]
        ];
    }
}