<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class EventResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'location' => $this->location,
            'start_date' => $this->start_date,
            'start_time' => $this->start_time,
            'end_date' => $this->end_date,
            'end_time' => $this->end_time,
            'cover_image' => getMedia($this->cover_image,'cover'),
            'event_url' => $this->event_url,
            'type' => $this->type,
            'is_going' => $this->isGoing(Auth::id()),
            'is_interested' => $this->isInterested(Auth::id()),
            'organizer' => new UserShortResource($this->organizer),
            'participants_count' => $this->participants->count(),
            'slug' => $this->slug,
            'category' => $this->category,
            'is_expired' => \Carbon\Carbon::parse($this->end_date)->isPast(),
            'is_going_on' => \Carbon\Carbon::parse($this->start_date)->isToday() || (\Carbon\Carbon::parse($this->start_date)->isPast() && \Carbon\Carbon::parse($this->end_date)->isFuture()),
            'already_joined' => $this->participants()->where('user_id', Auth::id())->exists() ? true : false,
            'associated_post' => $this->post ? [
                'id' => $this->post->id,
                'post_type' => $this->post->post_type,
                'post_text' => $this->post->post_text,
                'created_at' => $this->post->created_at,
            ] : null,
        ];
    }
}
