<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CourseResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'address' => $this->address,
            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            'category_id' => $this->category_id,
            'country' => $this->country,
            'level' => $this->level,
            'language' => $this->language,
            'description' => $this->description,
            'is_paid' => $this->is_paid,
            'amount' => $this->amount,
            'cover_url' => $this->cover ? asset('storage/' . $this->cover) : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'user' => new UserShortResource($this->user),
        ];
    }
}
