<?php

namespace App\Http\Resources;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class CommentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'post_id' => $this->post_id,
            'user' => new UserShortResource($this->whenLoaded('user')), // Ensuring user details are included
            'parent_id' => $this->parent_id,
            'content' => $this->content,
            'is_liked'=>(!empty(DB::table('comment_likes')->where(['comment_id'=> $this->id,'user_id'=>Auth::id()])->first()))?1:0,
            'likes_count' => $this->likes_count,
            'is_edited' => (bool) $this->is_edited,
            'created_at' => $this->created_at->toIso8601String(),
            'updated_at' => $this->updated_at->toIso8601String(),
            'replies' => CommentResource::collection($this->whenLoaded('replies')) // Recursively load replies
        ];
    }
}
