<?php

namespace App\Http\Resources\BloodBank;

use Illuminate\Http\Resources\Json\JsonResource;

class DonorResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'avatar' => $this->avatar,
            'blood_type' => $this->blood_type,
            'last_donation_date' => $this->last_donation_date ? $this->last_donation_date->format('Y-m-d') : null,
            'days_since_last_donation' => $this->days_since_last_donation,
            'donation_count' => $this->donation_count,
            'is_eligible_to_donate' => $this->isEligibleToDonate(),
            'distance' => $this->when(isset($this->distance), function () {
                return round($this->distance, 1);
            }),
        ];
    }
}