<?php

namespace App\Http\Resources\BloodBank;

use Illuminate\Http\Resources\Json\JsonResource;

class BloodDriveResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'blood_bank_id' => $this->blood_bank_id,
            'blood_bank' => new BloodBankResource($this->whenLoaded('bloodBank')),
            'organizer_name' => $this->organizer_name,
            'organizer_phone' => $this->organizer_phone,
            'organizer_email' => $this->organizer_email,
            'location' => $this->location,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'start_datetime' => $this->start_datetime->format('Y-m-d H:i:s'),
            'end_datetime' => $this->end_datetime->format('Y-m-d H:i:s'),
            'registration_limit' => $this->registration_limit,
            'registrations_count' => $this->whenLoaded('registrations', function() {
                return $this->registrations->count();
            }),
            'is_full' => $this->isRegistrationFull(),
            'is_in_progress' => $this->isInProgress(),
            'is_upcoming' => $this->start_datetime->isFuture(),
            'is_past' => $this->end_datetime->isPast(),
            'distance' => $this->when(isset($this->distance), function () {
                return round($this->distance, 1);
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'registrations' => DriveRegistrationResource::collection($this->whenLoaded('registrations')),
        ];
    }
}
