<?php

namespace App\Http\Resources\BloodBank;

use Illuminate\Http\Resources\Json\JsonResource;

class BloodBankResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'address' => $this->address,
            'phone' => $this->phone,
            'email' => $this->email,
            'description' => $this->description,
            'inventory' => BloodInventoryResource::collection($this->whenLoaded('inventory')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}