<?php

namespace App\Http\Requests\Messenger;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ConversationSearchRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'query' => ['required', 'string', 'min:2', 'max:100'],
            'type' => ['nullable', 'string', Rule::in(['dm', 'group', 'all'])],
            'limit' => ['nullable', 'integer', 'min:1', 'max:50'],
            'include_archived' => ['nullable', 'boolean'],
        ];
    }

    public function messages(): array
    {
        return [
            'query.required' => 'Search query is required.',
            'query.min' => 'Search query must be at least 2 characters.',
            'query.max' => 'Search query cannot exceed 100 characters.',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'type' => $this->type ?? 'all',
            'limit' => min($this->limit ?? 20, 50),
            'include_archived' => $this->boolean('include_archived', false),
        ]);
    }
}
