<?php

namespace App\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * @method static array store(\Illuminate\Http\UploadedFile $file, string $type = 'image', ?string $storageDriver = null, array $options = [])
 * @method static string getUrl(string $path, string $type = 'image', ?string $storageDriver = null, array $options = [])
 * @method static bool delete(string $path, ?string $storageDriver = null)
 * 
 * @see \App\Services\MediaService
 */
class Media extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'media';
    }
} 