<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\DB;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {
        // ...existing code...
        
        // Process email queue every 5 minutes
        $schedule->command('email:process-queue')->everyFiveMinutes();
        
        // Publish scheduled posts
        $schedule->call(function () {
            DB::table('posts')
                ->where('is_published', false)
                ->whereNotNull('scheduled_at')
                ->where('scheduled_at', '<=', now())
                ->update(['is_published' => true, 'updated_at' => now()]);
        })->everyMinute();
        
        // ...existing code...
    }

    // ...existing methods...
}