@extends("backend.layouts.app")

@section("title")
    Website Information
@endsection

@section("breadcrumbs")
    <x-backend.breadcrumbs>
        <x-backend.breadcrumb-item icon="c-icon fas fa-gear">
            Settings
        </x-backend.breadcrumb-item>
        <x-backend.breadcrumb-item type="active" icon="c-icon fa-solid fa-info-circle">
            Website Information
        </x-backend.breadcrumb-item>
    </x-backend.breadcrumbs>
@endsection

@section("content")
<link rel="stylesheet" href="{{asset('css/custom.css')}}">

    <div class="row">
        <div class="col-12 col-md-6 col-lg-6 col-xl-6 mb-2">
            <div class="card p-3 mb-3">
                <h5 class="card-title">
                    Website Information
                </h5>
                <div class="card-body">
                    <div class="form-group mb-3 border-b-2">
                        <label for="website_title">Website Title</label>
                        <input type="text" class="form-control" id="website_title" name="website_title" value="{{setting('website_title')}}">
                        <p class="admin-info">Your website general title, it will appear on Google and on your browser tab.</p> 
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="website_name">Website Name</label>
                        <input type="text" class="form-control" id="website_name" name="website_name" value="{{setting('website_name')}}">
                        <p class="admin-info">Your website name, it will on website's footer and E-mails.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="website_keywords">Website Keywords</label>
                        <input type="text" class="form-control" id="website_keywords" name="website_keywords" value="{{setting('website_keywords')}}">
                        <p class="admin-info">Your website's keyword, used mostly for SEO and search engines.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="website_description">Website Description</label>
                        <textarea name="website_description" id="website_description" class="form-control" rows="5">{{setting('website_description')}}</textarea>
                        <p class="admin-info">Your website's description, used mostly for SEO and search engines, Max of 100 characters is recommended
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="website_logo" class="mb-2 item-name">Website Logo</label>
                        <p class="admin-info">Change site's your logo here.
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="google_analytics_code">Google Analytics Code</label>
                        <textarea name="google_analytics_code" id="google_analytics_code" class="form-control" rows="5">{{setting('google_analytics_code')}}</textarea>
                        <p class="admin-info">Paste your full Google Analytics Code here to track traffic.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-6 col-lg-6 col-xl-6">
            <div class="card p-3 mb-3">
                <h5 class="card-title">
                    Features API Keys & Information
                </h5>
                <div class="card-body">
                    <div class="form-group mb-3 border-b-2">
                        <div class="d-flex justify-between">
                            <label for="google_map" class="mb-2 item-name">Google Maps</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input float-right" style="float: right" type="checkbox" role="switch" id="google_map" {{active_value_check(setting('google_map') ?? 0)}}>
                            </div>
                        </div>
                        <p class="admin-info">Show Google Map on (Posts, Profile, Settings, Ads).

                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="google_map_api">Google Map API</label>
                        <input class="form-control float-right" type="text" name="google_map_api" id="google_map_api" value="{{setting('google_map_api')}}">
                        <p class="admin-info">This key is required for GEO and viewing Google Maps.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <div class="d-flex justify-between">
                            <label for="yandex_map" class="mb-2 item-name">Yandex Maps</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input float-right" style="float: right" type="checkbox" role="switch" id="yandex_map" {{active_value_check(setting('yandex_map') ?? 0)}}>
                            </div>
                        </div>
                        <p class="admin-info">Show Yandex Map on (Posts, Profile, Settings, Ads).
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="yandex_map_api">Yandex Map API key</label>
                        <input class="form-control float-right" type="text" name="yandex_map_api" id="yandex_map_api" value="{{setting('yandex_map_api')}}">
                        <p class="admin-info">This key is required for GEO and viewing Yandex Maps.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <div class="d-flex justify-between">
                            <label for="yandex_translation" class="mb-2 item-name">Yandex Translation API</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input float-right" style="float: right" type="checkbox" role="switch" id="yandex_translation" {{active_value_check(setting('yandex_translation') ?? 0)}}>
                            </div>
                        </div>
                        <p class="admin-info">Translate post text.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="yandex_translation_api">Two-factor authentication</label>
                        <input class="form-control float-right" type="text" name="yandex_translation_api" id="yandex_translation_api" value="{{setting('yandex_translation_api')}}">
                        <p class="admin-info">This key is required for post translation.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <div class="d-flex justify-between">
                            <label for="google_translation" class="mb-2 item-name">Google Translation API</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input float-right" style="float: right" type="checkbox" role="switch" id="google_translation" {{active_value_check(setting('google_translation') ?? 0)}}>
                            </div>
                        </div>
                        <p class="admin-info">Translate post text.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="google_translation_api">Google Translation API Key</label>
                        <input class="form-control float-right" type="text" name="google_translation_api" id="google_translation_api" value="{{setting('google_translation_api')}}">
                        <p class="admin-info">This key is required for post translation.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="youtube_api_key">Youtube API Key</label>
                        <input class="form-control float-right" type="text" name="youtube_api_key" id="youtube_api_key" value="{{setting('youtube_api_key')}}">
                        <p class="admin-info">This key is required for importing or posting YouTube videos.</p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="giphy_api_key">Giphy API</label>
                        <input class="form-control float-right" type="text" name="giphy_api_key" id="giphy_api_key" value="{{setting('giphy_api_key')}}">
                        <p class="admin-info">This key is required for GIFs in messages, posts and comments.</p>
                    </div>
            </div>
        </div>
    </div>

    @include('admin.backend.layouts.update_settings')
@endsection
