<?php

namespace Modules\WebsiteInfo\Http\Controllers\Backend;

use App\Authorizable;
use App\Http\Controllers\Backend\BackendBaseController;
use App\Models\GeneralSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\WebsiteInfo\Models\WebsiteInfo;

class WebsiteInfosController extends BackendBaseController
{
    use Authorizable;

    public function __construct()
    {
        // Page Title
        $this->module_title = 'Website Information';

        // module name
        $this->module_name = 'Website Information';

        // directory path of the module
        $this->module_path = 'websiteinfo::backend';

        // module icon
        $this->module_icon = 'fa-regular fa-sun';

        // module model name, path
        $this->module_model = "Modules\WebsiteInfo\Models\WebsiteInfo";
    }

    public function index(){
        $setting = WebsiteInfo::first();
        return view('websiteinfo::backend.websiteinfos.index')->with(compact('setting'));
    }

    public function updateSiteInfo(Request $request){
        $request->validate([
            'name' => 'required',
            'value' => 'required',
        ]);
        $setting = WebsiteInfo::first();
        if($setting){
            $setting->update([$request->name => $request->value]);
        }else{
            WebsiteInfo::create([$request->name => $request->value]);
        }

        return true;
    }

}
