<?php

use Illuminate\Support\Facades\Route;
use Modules\EmailConfig\Http\Controllers\Backend\EmailConfigsController;

/*
*
* Backend Routes
*
* --------------------------------------------------------------------
*/
Route::group(['namespace' => '\Modules\EmailConfig\Http\Controllers\Backend', 'as' => 'backend.', 'middleware' => ['web', 'auth', 'can:view_backend'], 'prefix' => 'admin'], function () {
    /*
    * These routes need view-backend permission
    * (good if you want to allow more than one group in the backend,
    * then limit the backend features by different roles or permissions)
    *
    * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
    */

    /*
     *
     *  Backend EmailConfigs Routes
     *
     * ---------------------------------------------------------------------
     */
    $module_name = 'emailconfigs';
    $controller_name = 'EmailConfigsController';
    Route::get("Email/Config", [EmailConfigsController::class, 'index'])->name('email.config');
    Route::resource("$module_name", "$controller_name");
});
